// g++ -o test test.c
// g++ -O3 -o test test.c
// NON COMPATIBLE O3: il faudrait utiliser "volatile" pour pio par exemple - mais on semble limiter  2.5mhz en sortie
#include <stdlib.h>
#include <stdio.h>
#include "gpio_lib.c"

/* Comment trouver son numro de PIN ?
Dans "mapping.h", on a la structure :
typedef struct _pin {
    char name[10];          // The processor pin
    int offset;             // Memory offset for the pin
    int pin_number;         // Number on the connector
}pin_t;
suit sa dfinition : suffit de rechercher dedans - par exemple PIN "BCM_GPIO 17" nomm "PA1" sur port OrangePi broche 11 =>SUNXI_GPA(1)=>port SUNXI_GPA, bit 1
            {   "PA1",   SUNXI_GPA(1),   11  },
*/

#define PA1    SUNXI_GPA(1)

#define PIN_ACTION	PA1
/*
#define PD0    SUNXI_GPD(0)
#define PD1    SUNXI_GPD(1)
#define PD2    SUNXI_GPD(2)
#define PD3    SUNXI_GPD(3)
#define PD4    SUNXI_GPD(4)
#define PD5    SUNXI_GPD(5)
#define PD6    SUNXI_GPD(6)
#define PD7    SUNXI_GPD(7)
#define PD8    SUNXI_GPD(8)
#define PD9    SUNXI_GPD(9)
#define PD10    SUNXI_GPD(10)
#define PD11    SUNXI_GPD(11)
#define PD12    SUNXI_GPD(12)
#define PD13    SUNXI_GPD(13)
#define PD14    SUNXI_GPD(14)
#define PD15    SUNXI_GPD(15)
#define PD16    SUNXI_GPD(16)
#define PD17    SUNXI_GPD(17)
#define PD18    SUNXI_GPD(18)
#define PD19    SUNXI_GPD(19)
#define PD20    SUNXI_GPD(20)
#define PD21    SUNXI_GPD(21)
#define PD22    SUNXI_GPD(22)
#define PD23    SUNXI_GPD(23)
#define PD24    SUNXI_GPD(24)
#define PD25    SUNXI_GPD(25)
#define PD26    SUNXI_GPD(26)
#define PD27    SUNXI_GPD(27)

#define MISO    SUNXI_GPE(3)
#define MOSI    SUNXI_GPE(2)
#define SCK     SUNXI_GPE(1)
#define CS      SUNXI_GPE(0)
*/

int main()
{  if (sunxi_gpio_init() < 0)
   {  printf("Failed to initialize GPIO\n");
      return -1;
   }
   if (sunxi_gpio_set_cfgpin(PIN_ACTION,SUNXI_GPIO_OUTPUT) < 0)
   {  printf("Failed to config GPIO pin\n");
      return -1;
   }
   unsigned int bank = GPIO_BANK(PIN_ACTION);
   unsigned int num = GPIO_NUM(PIN_ACTION);
   printf("PIN %d (bank %d, bit %d)\n", PIN_ACTION, bank, num);
/*
   for (;;)
   {  sunxi_gpio_output(PIN_ACTION,1);
      sunxi_gpio_output(PIN_ACTION,0);
   }
*/
   int cpt, cumul = 0, nmax = 0;
   // Compil sans optimisation - nmax=1000=>50khz; nmax=100=>500khz; nmax<=10=>2.5MHz
   struct sunxi_gpio *pio;
   for (;;)
   {  pio = &((struct sunxi_gpio_reg *) SUNXI_PIO_BASE)->gpio_bank[bank];
      *(&pio->dat) |= 0x2;	// 0x1 << numbit
      for (cpt = 0; cpt < nmax; cpt++) cumul++;
      pio = &((struct sunxi_gpio_reg *) SUNXI_PIO_BASE)->gpio_bank[bank];
      *(&pio->dat) &= ~0x2;
      for (cpt = 0; cpt < nmax; cpt++) cumul++;
   }
/*
   // Compil sans optimisation 2.5MHz
   pio = &((struct sunxi_gpio_reg *) SUNXI_PIO_BASE)->gpio_bank[bank];
   for (;;)
   {  *(&pio->dat) |= 0x2;	// 0x1 << numbit
      *(&pio->dat) &= ~0x2;
   }
*/
/*
   int i;
   for (i=0;i<5;i++)
   {  if(sunxi_gpio_output(PIN_ACTION,1) < 0)
      {  printf("Failed to set GPIO pin value\n");
         return -1;
      }
      usleep(500000);
      if(sunxi_gpio_output(PIN_ACTION,0) < 0)
      {  printf("Failed to set GPIO pin value\n");
         return -1;
      }
      usleep(500000);
   }
*/
   sunxi_gpio_cleanup();
   return 0;
}
