// g++ -o testi testinput.c
// g++ -O3 -o testi testinput.c
// NON COMPATIBLE O3: il faudrait utiliser "volatile" pour pio par exemple - mais on semble limiter  2.5mhz en sortie
#include <stdlib.h>
#include <stdio.h>
#include "gpio_lib.c"

#include <iostream>
using namespace std;

/* Comment trouver son numro de PIN ?
Dans "mapping.h", on a la structure :
typedef struct _pin {
    char name[10];          // The processor pin
    int offset;             // Memory offset for the pin
    int pin_number;         // Number on the connector
}pin_t;
suit sa dfinition : suffit de rechercher dedans - par exemple PIN "BCM_GPIO 17" nomm "PA1" sur port OrangePi broche 11 =>SUNXI_GPA(1)=>port SUNXI_GPA, bit 1
            {   "PA1",   SUNXI_GPA(1),   11  },
*/

/* Autres valeurs:
#define PA1    SUNXI_GPA(1)
...
#define PD0    SUNXI_GPD(0)
#define PD1    SUNXI_GPD(1)
#define PD2    SUNXI_GPD(2)
#define PD3    SUNXI_GPD(3)
...
#define MISO    SUNXI_GPE(3)
#define MOSI    SUNXI_GPE(2)
#define SCK     SUNXI_GPE(1)
#define CS      SUNXI_GPE(0)
*/

int main()
{  // Init SUNXI_PIO_BASE (utilise SW_PORTC_IO_BASE)
   if (sunxi_gpio_init() < 0)
   {  printf("Failed to initialize GPIO\n");
      return -1;
   }
   char port;
   int oriport, cmd, pinport, nbtst = 20, idx, pinacces, ok;
   for (;;)
   {  cmd = 0;
      cout << "Port a,c,d,g sinon x pour quitter !" << endl;
      cin >> port;
      switch (port)
      {  case 'a' : oriport = SUNXI_GPIO_A_START; break;
         case 'c' : oriport = SUNXI_GPIO_C_START; break;
         case 'd' : oriport = SUNXI_GPIO_D_START; break;
         case 'g' : oriport = SUNXI_GPIO_G_START; break;
         case 'x' : cmd = 1; break;
         default: cout << "Port incorrect !" << endl; cmd = -1; break;
      }
      if (cmd < 0) continue;
      if (cmd > 0) break;
      //
      for (;;)
      {  cout << "Port " << port << ": bit ? ou -1 pour stopper" << endl;
         cin >> pinport;
         if ((pinport < 0) || (pinport >= 32)) break;
         pinacces = oriport + pinport;			// modele pris sur SUNXI_GPA(_nr)
         if (sunxi_gpio_set_cfgpin(pinacces,SUNXI_GPIO_INPUT) < 0)
         {  cout << "Failed to config GPIO pin" << endl;
            continue;
         }
         struct sunxi_gpio *pio;
         unsigned int bank = GPIO_BANK(pinacces);
         unsigned int num = GPIO_NUM(pinacces);
         unsigned int msk = 0x1 << num;
         pio = &((struct sunxi_gpio_reg *) SUNXI_PIO_BASE)->gpio_bank[bank];
         for (idx = 0; idx < nbtst; idx++)
         {  sleep(1);
            ok = pio->dat & msk;
            if (ok) ok = 1;
            cout << "P" << port << pinport << "=" << ok << endl;
         }
      }
   }
   sunxi_gpio_cleanup();
   return 0;
}
